package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class DefaultResources(
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the name of the default Firebase Hosting site using [ListSites](https://firebase.google.com/docs/reference/hosting/rest/v1beta1/projects.sites/list) within the Firebase Hosting REST API. If the default Hosting site for the Project has not yet been provisioned, the return might not contain a default site._ The name of the default Firebase Hosting site, in the format: PROJECT_ID Though rare, your `projectId` might already be used as the name for an existing Hosting site in another project (learn more about creating non-default, [additional sites](https://firebase.google.com/docs/hosting/multisites)). In these cases, your `projectId` is appended with a hyphen then five alphanumeric characters to create your default Hosting site name. For example, if your `projectId` is `myproject123`, your default Hosting site name might be: `myproject123-a5c16`
      */
    hostingSite: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of each resource in a Project. This field may not be populated, especially for newly provisioned projects after October 30, 2024._ The ID of the Project's ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location), which are resources associated with Google App Engine. The location is one of the available [Google App Engine locations](https://cloud.google.com/about/locations#region). This field is omitted if the location for default Google Cloud resources has not been set.
      */
    locationId: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the name of the default Realtime Database instance using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. If the default Realtime Database instance for a Project has not yet been provisioned, the return might not contain a default instance._ The default Firebase Realtime Database instance name, in the format: PROJECT_ID Though rare, your `projectId` might already be used as the name for an existing Realtime Database instance in another project (learn more about [database sharding](https://firebase.google.com/docs/database/usage/sharding)). In these cases, your `projectId` is appended with a hyphen then five alphanumeric characters to create your default Realtime Database instance name. For example, if your `projectId` is `myproject123`, your default database instance name might be: `myproject123-a5c16`
      */
    realtimeDatabaseInstance: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the name of the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. If the default bucket for the Project has not yet been provisioned, the return might not contain a default bucket._ The name of the default Cloud Storage for Firebase bucket, in one of the following formats:
      * If provisioned _before_ October 30, 2024: PROJECT_ID.firebasestorage.app
      * If provisioned _on or after_ October 30, 2024: PROJECT_ID.firebasestorage.app
      */
    storageBucket: Option[String] = None,
)
object DefaultResources {
  implicit val encoder: Encoder[DefaultResources] = Encoder.instance { x =>
    Json.obj(
      "hostingSite" := x.hostingSite,
      "locationId" := x.locationId,
      "realtimeDatabaseInstance" := x.realtimeDatabaseInstance,
      "storageBucket"
        := x.storageBucket,
    )
  }
  implicit val decoder: Decoder[DefaultResources] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("hostingSite")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("realtimeDatabaseInstance")
      v3 <- c.get[Option[String]]("storageBucket")
    } yield DefaultResources(v0, v1, v2, v3)
  }
}
