package googleapis.firebase

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.client.Client

class AvailableProjectsClient[F[_]: Concurrent](client: Client[F])
    extends AbstractClient[F](client) {
  val baseUri = uri"https://firebase.googleapis.com/"
  def list(
      query: AvailableProjectsClient.ListParams = AvailableProjectsClient.ListParams()
  ): F[ListAvailableProjectsResponse] = expectJson[ListAvailableProjectsResponse](
    request(
      method = Method.GET,
      uri = (baseUri / "v1beta1" / "availableProjects").copy(query =
        Query.fromVector(
          Vector(
            List("pageSize" -> query.pageSize.map(s => QueryParamEncoder[Int].encode(s).value))
              .flatMap { case (k, v) => v.map(vv => k -> Option(vv)) },
            List("pageToken" -> query.pageToken).flatMap { case (k, v) =>
              v.map(vv => k -> Option(vv))
            },
          ).flatten
        )
      ),
    )
  )
}
object AvailableProjectsClient {
  final case class ListParams(
      /** The maximum number of Projects to return in the response. The server may return fewer than this value at its discretion. If no value is specified (or too large a value is specified), the server will impose its own limit. This value cannot be negative.
        */
      pageSize: Option[Int] = None,
      /** Token returned from a previous call to `ListAvailableProjects` indicating where in the set of Projects to resume listing.
        */
      pageToken: Option[String] = None,
  )
}
