package googleapis.firebase

import io.circe._

sealed abstract class AndroidAppState(val value: String) extends Product with Serializable
object AndroidAppState {

  /** Unspecified state.
    */
  case object STATE_UNSPECIFIED extends AndroidAppState("STATE_UNSPECIFIED")

  /** The App is active.
    */
  case object ACTIVE extends AndroidAppState("ACTIVE")

  /** The App has been soft-deleted. After an App has been in the `DELETED` state for more than 30 days, it is considered expired and will be permanently deleted. Up until this time, you can restore the App by calling `Undelete` ([Android](projects.androidApps/undelete) | [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
    */
  case object DELETED extends AndroidAppState("DELETED")
  val values = List(STATE_UNSPECIFIED, ACTIVE, DELETED)
  def fromString(input: String): Either[String, AndroidAppState] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for AndroidAppState")
  implicit val decoder: Decoder[AndroidAppState] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[AndroidAppState] = Encoder[String].contramap(_.value)
}
