package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AnalyticsProperty(
    /** Output only. The ID of the [Google Analytics account](https://www.google.com/analytics/) for the Google Analytics property associated with the specified FirebaseProject.
      */
    analyticsAccountId: Option[String] = None,
    /** The display name of the Google Analytics property associated with the specified `FirebaseProject`.
      */
    displayName: Option[String] = None,
    /** The globally unique, Google-assigned identifier of the Google Analytics property associated with the specified `FirebaseProject`. If you called [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics) to link the `FirebaseProject` with a Google Analytics account, the value in this `id` field is the same as the ID of the property either specified or provisioned with that call to `AddGoogleAnalytics`.
      */
    id: Option[String] = None,
)
object AnalyticsProperty {
  implicit val encoder: Encoder[AnalyticsProperty] = Encoder.instance { x =>
    Json.obj(
      "analyticsAccountId" := x.analyticsAccountId,
      "displayName" := x.displayName,
      "id" := x.id,
    )
  }
  implicit val decoder: Decoder[AnalyticsProperty] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("analyticsAccountId")
      v1 <- c.get[Option[String]]("displayName")
      v2 <- c.get[Option[String]]("id")
    } yield AnalyticsProperty(v0, v1, v2)

  }
}
