package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AnalyticsDetails(
    /** The Analytics Property object associated with the specified `FirebaseProject`. This object contains the details of the Google Analytics property associated with the Project.
      */
    analyticsProperty: Option[AnalyticsProperty] = None,
    /**  - For `AndroidApps` and `IosApps`: a map of `app` to `streamId` for each Firebase App in the specified `FirebaseProject`. Each `app` and `streamId` appears only once. - For `WebApps`: a map of `app` to `streamId` and `measurementId` for each `WebApp` in the specified `FirebaseProject`. Each `app`, `streamId`, and `measurementId` appears only once.
      */
    streamMappings: Option[List[StreamMapping]] = None,
)
object AnalyticsDetails {
  implicit val encoder: Encoder[AnalyticsDetails] = Encoder.instance { x =>
    Json.obj(
      "analyticsProperty" := x.analyticsProperty,
      "streamMappings" := x.streamMappings,
    )
  }
  implicit val decoder: Decoder[AnalyticsDetails] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[AnalyticsProperty]]("analyticsProperty")
      v1 <- c.get[Option[List[StreamMapping]]]("streamMappings")
    } yield AnalyticsDetails(v0, v1)
  }
}
