package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AdminSdkConfig(
    /** \*\*DEPRECATED.\*\* _Instead, find the URL of the default Realtime Database instance using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. If the default instance for the Project has not yet been provisioned, the return might not contain a default instance. Note that the config that's generated for the Firebase console or the Firebase CLI uses the Realtime Database endpoint to populate this value for that config._ The URL of the default Firebase Realtime Database instance.
      */
    databaseURL: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of each resource in a Project. This field may not be populated, especially for newly provisioned projects after October 30, 2024._ The ID of the Project's ["location for default Google Cloud resources"](https://firebase.google.com/docs/projects/locations#default-cloud-location), which are resources associated with Google App Engine. The location is one of the available [App Engine locations](https://cloud.google.com/about/locations#region). This field is omitted if the location for default Google Cloud resources has not been set.
      */
    locationId: Option[String] = None,
    /** Immutable. A user-assigned unique identifier for the `FirebaseProject`. This identifier may appear in URLs or names for some Firebase resources associated with the Project, but it should generally be treated as a convenience alias to reference the Project.
      */
    projectId: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the name of the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. If the default bucket for the Project has not yet been provisioned, the return might not contain a default bucket. Note that the config that's generated for the Firebase console or the Firebase CLI uses the Cloud Storage for Firebase endpoint to populate this value for that config._ The name of the default Cloud Storage for Firebase bucket.
      */
    storageBucket: Option[String] = None,
)
object AdminSdkConfig {
  implicit val encoder: Encoder[AdminSdkConfig] = Encoder.instance { x =>
    Json.obj(
      "databaseURL" := x.databaseURL,
      "locationId" := x.locationId,
      "projectId"
        := x.projectId,
      "storageBucket" := x.storageBucket,
    )
  }
  implicit val decoder: Decoder[AdminSdkConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("databaseURL")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("projectId")
      v3 <- c.get[Option[String]]("storageBucket")
    } yield AdminSdkConfig(v0, v1, v2, v3)
  }
}
