package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class WebAppConfig(
    /** The sender ID for use with Firebase Cloud Messaging.
      */
    messagingSenderId: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the default Firebase Realtime Database instance name using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. Note that the default instance for the Project might not yet be provisioned, so the return might not contain a default instance._ The default Firebase Realtime Database URL.
      */
    databaseURL: Option[String] = None,
    /** The domain Firebase Auth configures for OAuth redirects, in the format: PROJECT_ID.firebaseapp.com
      */
    authDomain: Option[String] = None,
    /** Immutable. A user-assigned unique identifier for the `FirebaseProject`.
      */
    projectId: Option[String] = None,
    /** The [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key associated with the `WebApp`. Note that this value is _not_ the [`apiKeyId`](../projects.webApps#WebApp.FIELDS.api_key_id) (the UID) of the API key associated with the `WebApp`.
      */
    apiKey: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of resources._ The ID of the Project's default GCP resource location. The location is one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations). This field is omitted if the default GCP resource location has not been finalized yet. To set a Project's default GCP resource location, call [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize) after you add Firebase resources to the Project.
      */
    locationId: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. Note that the default bucket for the Project might not yet be provisioned, so the return might not contain a default bucket._ The default Cloud Storage for Firebase storage bucket name.
      */
    storageBucket: Option[String] = None,
    /** Immutable. The globally unique, Firebase-assigned identifier for the `WebApp`.
      */
    appId: Option[String] = None,
    /** The unique Google-assigned identifier of the Google Analytics web stream associated with the `WebApp`. Firebase SDKs use this ID to interact with Google Analytics APIs. This field is only present if the `WebApp` is linked to a web stream in a Google Analytics App + Web property. Learn more about this ID and Google Analytics web streams in the [Analytics documentation](https://support.google.com/analytics/answer/9304153). To generate a `measurementId` and link the `WebApp` with a Google Analytics web stream, call [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics). For apps using the Firebase JavaScript SDK v7.20.0 and later, Firebase dynamically fetches the `measurementId` when your app initializes Analytics. Having this ID in your config object is optional, but it does serve as a fallback in the rare case that the dynamic fetch fails.
      */
    measurementId: Option[String] = None,
)
object WebAppConfig {
  implicit val encoder: Encoder[WebAppConfig] = Encoder.instance { x =>
    Json.obj(
      "messagingSenderId" := x.messagingSenderId,
      "databaseURL" := x.databaseURL,
      "authDomain" := x.authDomain,
      "projectId" := x.projectId,
      "apiKey" := x.apiKey,
      "locationId" := x.locationId,
      "storageBucket" := x.storageBucket,
      "appId" := x.appId,
      "measurementId" := x.measurementId,
    )
  }
  implicit val decoder: Decoder[WebAppConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("messagingSenderId")
      v1 <- c.get[Option[String]]("databaseURL")
      v2 <- c.get[Option[String]]("authDomain")
      v3 <- c.get[Option[String]]("projectId")
      v4 <- c.get[Option[String]]("apiKey")
      v5 <- c.get[Option[String]]("locationId")
      v6 <- c.get[Option[String]]("storageBucket")
      v7 <- c.get[Option[String]]("appId")
      v8 <- c.get[Option[String]]("measurementId")
    } yield WebAppConfig(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
