package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class UndeleteIosAppRequest(
    /** Checksum provided in the IosApp resource. If provided, this checksum ensures that the client has an up-to-date value before proceeding.
      */
    etag: Option[String] = None,
    /** If set to true, the request is only validated. The App will _not_ be undeleted.
      */
    validateOnly: Option[Boolean] = None,
)
object UndeleteIosAppRequest {
  implicit val encoder: Encoder[UndeleteIosAppRequest] = Encoder.instance { x =>
    Json.obj("etag" := x.etag, "validateOnly" := x.validateOnly)
  }
  implicit val decoder: Decoder[UndeleteIosAppRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[Boolean]]("validateOnly")
    } yield UndeleteIosAppRequest(v0, v1)

  }
}
