package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class StatusProto(
    /** message_set associates an arbitrary proto message with the status.
      */
    messageSet: Option[MessageSet] = None,
    /** Numeric code drawn from the space specified below. Often, this is the canonical error space, and code is drawn from google3/util/task/codes.proto
      */
    code: Option[Int] = None,
    /** The following are usually only present when code != 0 Space to which this status belongs
      */
    space: Option[String] = None,
    /** The canonical error code (see codes.proto) that most closely corresponds to this status. This may be missing, and in the common case of the generic space, it definitely will be.
      */
    canonicalCode: Option[Int] = None,
    /** Detail message
      */
    message: Option[String] = None,
)
object StatusProto {
  implicit val encoder: Encoder[StatusProto] = Encoder.instance { x =>
    Json.obj(
      "messageSet" := x.messageSet,
      "code" := x.code,
      "space" := x.space,
      "canonicalCode" := x.canonicalCode,
      "message" := x.message,
    )
  }
  implicit val decoder: Decoder[StatusProto] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[MessageSet]]("messageSet")
      v1 <- c.get[Option[Int]]("code")
      v2 <- c.get[Option[String]]("space")
      v3 <- c.get[Option[Int]]("canonicalCode")
      v4 <- c.get[Option[String]]("message")
    } yield StatusProto(v0, v1, v2, v3, v4)
  }
}
