package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ShaCertificate(
    /** The type of SHA certificate encoded in the hash.
      */
    certType: Option[ShaCertificateCertType] = None,
    /** The resource name of the ShaCertificate for the AndroidApp, in the format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID/sha/SHA_HASH
      * PROJECT_IDENTIFIER: the parent Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) \*\*\*(recommended)\*\*\* or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
      * APP_ID: the globally unique, Firebase-assigned identifier for the App (see [`appId`](../projects.androidApps#AndroidApp.FIELDS.app_id)).
      * SHA_HASH: the certificate hash for the App (see [`shaHash`](../projects.androidApps.sha#ShaCertificate.FIELDS.sha_hash)).
      */
    name: Option[String] = None,
    /** The certificate hash for the `AndroidApp`.
      */
    shaHash: Option[String] = None,
)
object ShaCertificate {
  implicit val encoder: Encoder[ShaCertificate] = Encoder.instance { x =>
    Json.obj("certType" := x.certType, "name" := x.name, "shaHash" := x.shaHash)
  }
  implicit val decoder: Decoder[ShaCertificate] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ShaCertificateCertType]]("certType")
      v1 <- c.get[Option[String]]("name")
      v2 <- c.get[Option[String]]("shaHash")
    } yield ShaCertificate(v0, v1, v2)
  }
}
