package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class SearchFirebaseAppsResponse(
    /** One page of results from a call to `SearchFirebaseApps`.
      */
    apps: Option[List[FirebaseAppInfo]] = None,
    /** If the result list is too large to fit in a single response, then a token is returned. This token can be used in a subsequent calls to `SearchFirebaseApps` to find the next group of Apps. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
)
object SearchFirebaseAppsResponse {
  implicit val encoder: Encoder[
    SearchFirebaseAppsResponse
  ] = Encoder.instance { x =>
    Json.obj("apps" := x.apps, "nextPageToken" := x.nextPageToken)
  }
  implicit val decoder: Decoder[
    SearchFirebaseAppsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[FirebaseAppInfo]]]("apps")
      v1 <- c.get[Option[String]]("nextPageToken")
    } yield SearchFirebaseAppsResponse(v0, v1)
  }
}
