package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class RemoveWebAppRequest(
    /** If set to true, and the App is not found, the request will succeed but no action will be taken on the server.
      */
    allowMissing: Option[Boolean] = None,
    /** Checksum provided in the WebApp resource. If provided, this checksum ensures that the client has an up-to-date value before proceeding.
      */
    etag: Option[String] = None,
    /** Determines whether to _immediately_ delete the WebApp. If set to true, the App is immediately deleted from the Project and cannot be restored to the Project. If not set, defaults to false, which means the App will be set to expire in 30 days. Within the 30 days, the App may be restored to the Project using UndeleteWebApp
      */
    immediate: Option[Boolean] = None,
    /** If set to true, the request is only validated. The App will _not_ be removed.
      */
    validateOnly: Option[Boolean] = None,
)
object RemoveWebAppRequest {
  implicit val encoder: Encoder[RemoveWebAppRequest] = Encoder.instance { x =>
    Json.obj(
      "allowMissing" := x.allowMissing,
      "etag" := x.etag,
      "immediate" := x.immediate,
      "validateOnly" := x.validateOnly,
    )
  }
  implicit val decoder: Decoder[RemoveWebAppRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("allowMissing")
      v1 <- c.get[Option[String]]("etag")
      v2 <- c.get[Option[Boolean]]("immediate")
      v3 <- c.get[Option[Boolean]]("validateOnly")
    } yield RemoveWebAppRequest(v0, v1, v2, v3)

  }
}
