package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class RemoveAnalyticsRequest(
    /** Optional. The ID of the Google Analytics property associated with the specified `FirebaseProject`. - If not set, then the Google Analytics property that is currently associated with the specified `FirebaseProject` is removed. - If set, and the specified `FirebaseProject` is currently associated with a \*different\* Google Analytics property, then the response is a `412 Precondition Failed` error.
      */
    analyticsPropertyId: Option[String] = None
)
object RemoveAnalyticsRequest {
  implicit val encoder: Encoder[RemoveAnalyticsRequest] = Encoder.instance { x =>
    Json.obj("analyticsPropertyId" := x.analyticsPropertyId)
  }
  implicit val decoder: Decoder[
    RemoveAnalyticsRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("analyticsPropertyId")
    } yield RemoveAnalyticsRequest(v0)
  }
}
