package googleapis.firebase

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.client.Client

class ProjectsAvailableLocationsClient[F[_]: Concurrent](client: Client[F])
    extends AbstractClient[F](client) {
  val baseUri = uri"https://firebase.googleapis.com/"
  def list(
      /** The FirebaseProject for which to list GCP resource locations, in the format: projects/PROJECT_IDENTIFIER Refer to the `FirebaseProject` [`name`](../projects#FirebaseProject.FIELDS.name) field for details about PROJECT_IDENTIFIER values. If no unique project identifier is specified (that is, `projects/-`), the returned list does not take into account org-specific or project-specific location restrictions.
        */
      parent: String,
      query: ProjectsAvailableLocationsClient.ListParams =
        ProjectsAvailableLocationsClient.ListParams(),
  ): F[ListAvailableLocationsResponse] = expectJson[ListAvailableLocationsResponse](
    request(
      method = Method.GET,
      uri = (baseUri / "v1beta1" / s"${parent}" / "availableLocations").copy(query =
        Query(
          "pageSize" -> query.pageSize.map(s => QueryParamEncoder[Int].encode(s).value),
          "pageToken" -> query.pageToken,
        )
      ),
    )
  )
}
object ProjectsAvailableLocationsClient {
  final case class ListParams(
      /** The maximum number of locations to return in the response. The server may return fewer than this value at its discretion. If no value is specified (or too large a value is specified), then the server will impose its own limit. This value cannot be negative.
        */
      pageSize: Option[Int] = None,
      /** Token returned from a previous call to `ListAvailableLocations` indicating where in the list of locations to resume listing.
        */
      pageToken: Option[String] = None,
  )
}
