package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ProjectInfo(
    /** The user-assigned display name of the GCP `Project`, for example: `My App`
      */
    displayName: Option[String] = None,
    /** The ID of the Project's default GCP resource location. The location is one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations). Not all Projects will have this field populated. If it is not populated, it means that the Project does not yet have a default GCP resource location. To set a Project's default GCP resource location, call [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize) after you add Firebase resources to the Project.
      */
    locationId: Option[String] = None,
    /** The resource name of the GCP `Project` to which Firebase resources can be added, in the format: projects/PROJECT_IDENTIFIER Refer to the `FirebaseProject` [`name`](../projects#FirebaseProject.FIELDS.name) field for details about PROJECT_IDENTIFIER values.
      */
    project: Option[String] = None,
)
object ProjectInfo {
  implicit val encoder: Encoder[ProjectInfo] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "locationId" := x.locationId,
      "project" :=
        x.project,
    )
  }
  implicit val decoder: Decoder[ProjectInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("project")
    } yield ProjectInfo(v0, v1, v2)
  }
}
