package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ProductMetadata(
    /** List of warnings related to the associated operation.
      */
    warningMessages: Option[List[String]] = None
)
object ProductMetadata {
  implicit val encoder: Encoder[ProductMetadata] = Encoder.instance { x =>
    Json.obj("warningMessages" := x.warningMessages)
  }
  implicit val decoder: Decoder[ProductMetadata] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("warningMessages")
    } yield ProductMetadata(v0)
  }
}
