package googleapis.firebase

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.client.Client

class OperationsClient[F[_]: Concurrent](client: Client[F]) extends AbstractClient[F](client) {
  val baseUri = uri"https://firebase.googleapis.com/"
  def get(
      /** The name of the operation resource.
        */
      name: String
  ): F[Operation] =
    expectJson[Operation](request(method = Method.GET, uri = baseUri / "v1beta1" / s"${name}"))
}
