package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class OperationMetadata(value: Option[JsonObject] = None)
object OperationMetadata {
  implicit val encoder: Encoder[OperationMetadata] = Encoder.instance { x =>
    Json.obj("value" := x.value)
  }
  implicit val decoder: Decoder[OperationMetadata] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[JsonObject]]("value")
    } yield OperationMetadata(v0)

  }
}
