package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class MessageSet(value: Option[JsonObject] = None)
object MessageSet {
  implicit val encoder: Encoder[MessageSet] = Encoder.instance { x =>
    Json.obj("value" := x.value)
  }
  implicit val decoder: Decoder[MessageSet] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[JsonObject]]("value")
    } yield MessageSet(v0)
  }
}
