package googleapis.firebase

import io.circe._

sealed abstract class LocationType(val value: String) extends Product with Serializable
object LocationType {

  /** Used internally for distinguishing unset values and is not intended for external use.
    */
  case object LOCATION_TYPE_UNSPECIFIED extends LocationType("LOCATION_TYPE_UNSPECIFIED")

  /** The location is a regional location. Data in a regional location is replicated in multiple zones within a region.
    */
  case object REGIONAL extends LocationType("REGIONAL")

  /** The location is a multi-regional location. Data in a multi-region location is replicated in multiple regions. Within each region, data is replicated in multiple zones.
    */
  case object MULTI_REGIONAL extends LocationType("MULTI_REGIONAL")
  val values = List(LOCATION_TYPE_UNSPECIFIED, REGIONAL, MULTI_REGIONAL)
  def fromString(input: String): Either[String, LocationType] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for LocationType")
  implicit val decoder: Decoder[LocationType] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[LocationType] = Encoder[String].contramap(_.value)
}
