package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListWebAppsResponse(
    /** List of each `WebApp` associated with the specified `FirebaseProject`.
      */
    apps: Option[List[WebApp]] = None,
    /** If the result list is too large to fit in a single response, then a token is returned. If the string is empty, then this response is the last page of results. This token can be used in a subsequent call to `ListWebApps` to find the next group of Apps. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
)
object ListWebAppsResponse {
  implicit val encoder: Encoder[ListWebAppsResponse] = Encoder.instance { x =>
    Json.obj("apps" := x.apps, "nextPageToken" := x.nextPageToken)
  }
  implicit val decoder: Decoder[ListWebAppsResponse] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[WebApp]]]("apps")
      v1 <- c.get[Option[String]]("nextPageToken")
    } yield ListWebAppsResponse(v0, v1)

  }
}
