package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListShaCertificatesResponse(
    /** The list of each `ShaCertificate` associated with the `AndroidApp`.
      */
    certificates: Option[List[ShaCertificate]] = None
)
object ListShaCertificatesResponse {
  implicit val encoder: Encoder[
    ListShaCertificatesResponse
  ] = Encoder.instance(x => Json.obj("certificates" := x.certificates))
  implicit val decoder: Decoder[
    ListShaCertificatesResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[ShaCertificate]]]("certificates")
    } yield ListShaCertificatesResponse(v0)
  }
}
