package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListAvailableProjectsResponse(
    /** If the result list is too large to fit in a single response, then a token is returned. If the string is empty, then this response is the last page of results. This token can be used in a subsequent calls to `ListAvailableProjects` to find the next group of Projects. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
    /** The list of GCP `Projects` which can have Firebase resources added to them.
      */
    projectInfo: Option[List[ProjectInfo]] = None,
)
object ListAvailableProjectsResponse {
  implicit val encoder: Encoder[
    ListAvailableProjectsResponse
  ] = Encoder.instance { x =>
    Json.obj("nextPageToken" := x.nextPageToken, "projectInfo" := x.projectInfo)
  }
  implicit val decoder: Decoder[
    ListAvailableProjectsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("nextPageToken")
      v1 <- c.get[Option[List[ProjectInfo]]]("projectInfo")
    } yield ListAvailableProjectsResponse(v0, v1)
  }
}
