package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class ListAndroidAppsResponse(
    /** List of each `AndroidApp` associated with the specified `FirebaseProject`.
      */
    apps: Option[List[AndroidApp]] = None,
    /** If the result list is too large to fit in a single response, then a token is returned. If the string is empty, then this response is the last page of results. This token can be used in a subsequent call to `ListAndroidApps` to find the next group of Apps. Page tokens are short-lived and should not be persisted.
      */
    nextPageToken: Option[String] = None,
)
object ListAndroidAppsResponse {
  implicit val encoder: Encoder[
    ListAndroidAppsResponse
  ] = Encoder.instance { x =>
    Json.obj("apps" := x.apps, "nextPageToken" := x.nextPageToken)
  }
  implicit val decoder: Decoder[
    ListAndroidAppsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[AndroidApp]]]("apps")
      v1 <- c.get[Option[String]]("nextPageToken")
    } yield ListAndroidAppsResponse(v0, v1)
  }
}
