package googleapis.firebase

import io.circe._
import scala.concurrent.duration._
import scodec.bits._

private[firebase] object JsonInstances {
  implicit val durationEncoder: Encoder[FiniteDuration] = Encoder[Long].contramap(_.toMillis)
  implicit val durationDecoder: Decoder[FiniteDuration] = Decoder[Long].map(_.millis)

  implicit val byteVectorEncoder: Encoder[ByteVector] = Encoder[String].contramap(_.toBase64)
  implicit val byteVectorDecoder: Decoder[ByteVector] =
    Decoder[String].emap(bv => ByteVector.fromBase64Descriptive(bv))
}
