package googleapis.firebase

import io.circe._

sealed abstract class IosAppState(val value: String) extends Product with Serializable
object IosAppState {

  /** Unspecified state.
    */
  case object STATE_UNSPECIFIED extends IosAppState("STATE_UNSPECIFIED")

  /** The App is active.
    */
  case object ACTIVE extends IosAppState("ACTIVE")

  /** The App has been soft-deleted. After an App has been in the `DELETED` state for more than 30 days, it is considered expired and will be permanently deleted. Up until this time, you can restore the App by calling `Undelete` ([Android](projects.androidApps/undelete) | [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
    */
  case object DELETED extends IosAppState("DELETED")
  val values = List(STATE_UNSPECIFIED, ACTIVE, DELETED)
  def fromString(input: String): Either[String, IosAppState] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for IosAppState")
  implicit val decoder: Decoder[IosAppState] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[IosAppState] = Encoder[String].contramap(_.value)
}
