package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class IosApp(
    /** The user-assigned display name for the `IosApp`.
      */
    displayName: Option[String] = None,
    /** Output only. Timestamp of when the App will be considered expired and cannot be undeleted. This value is only provided if the App is in the `DELETED` state.
      */
    expireTime: Option[String] = None,
    /** This checksum is computed by the server based on the value of other fields, and it may be sent with update requests to ensure the client has an up-to-date value before proceeding. Learn more about `etag` in Google's [AIP-154 standard](https://google.aip.dev/154#declarative-friendly-resources). This etag is strongly validated.
      */
    etag: Option[String] = None,
    /** Immutable. The canonical bundle ID of the iOS app as it would appear in the iOS AppStore.
      */
    bundleId: Option[String] = None,
    /** The resource name of the IosApp, in the format: projects/PROJECT_IDENTIFIER /iosApps/APP_ID
      * PROJECT_IDENTIFIER: the parent Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) \*\*\*(recommended)\*\*\* or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
      * APP_ID: the globally unique, Firebase-assigned identifier for the App (see [`appId`](../projects.iosApps#IosApp.FIELDS.app_id)).
      */
    name: Option[String] = None,
    /** Output only. The lifecycle state of the App.
      */
    state: Option[IosAppState] = None,
    /** The Apple Developer Team ID associated with the App in the App Store.
      */
    teamId: Option[String] = None,
    /** The automatically generated Apple ID assigned to the iOS app by Apple in the iOS App Store.
      */
    appStoreId: Option[String] = None,
    /** Output only. Immutable. A user-assigned unique identifier of the parent FirebaseProject for the `IosApp`.
      */
    projectId: Option[String] = None,
    /** The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the `IosApp`. Be aware that this value is the UID of the API key, _not_ the [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key. The `keyString` is the value that can be found in the App's [configuration artifact](../../rest/v1beta1/projects.iosApps/getConfig). If `api_key_id` is not set in requests to [`iosApps.Create`](../../rest/v1beta1/projects.iosApps/create), then Firebase automatically associates an `api_key_id` with the `IosApp`. This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned. In patch requests, `api_key_id` cannot be set to an empty value, and the new UID must have no restrictions or only have restrictions that are valid for the associated `IosApp`. We recommend using the [Google Cloud Console](https://console.cloud.google.com/apis/credentials) to manage API keys.
      */
    apiKeyId: Option[String] = None,
    /** Output only. Immutable. The globally unique, Firebase-assigned identifier for the `IosApp`. This identifier should be treated as an opaque token, as the data format is not specified.
      */
    appId: Option[String] = None,
)
object IosApp {
  implicit val encoder: Encoder[IosApp] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "expireTime" := x.expireTime,
      "etag" := x.etag,
      "bundleId" := x.bundleId,
      "name" := x.name,
      "state" := x.state,
      "teamId" := x.teamId,
      "appStoreId" := x.appStoreId,
      "projectId" := x.projectId,
      "apiKeyId" := x.apiKeyId,
      "appId" := x.appId,
    )
  }
  implicit val decoder: Decoder[IosApp] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("expireTime")
      v2 <- c.get[Option[String]]("etag")
      v3 <- c.get[Option[String]]("bundleId")
      v4 <- c.get[Option[String]]("name")
      v5 <- c.get[Option[IosAppState]]("state")
      v6 <- c.get[Option[String]]("teamId")
      v7 <- c.get[Option[String]]("appStoreId")
      v8 <- c.get[Option[String]]("projectId")
      v9 <- c.get[Option[String]]("apiKeyId")
      v10 <- c.get[Option[String]]("appId")
    } yield IosApp(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10)
  }
}
