package googleapis.firebase

import io.circe._

sealed abstract class FirebaseProjectState(val value: String) extends Product with Serializable
object FirebaseProjectState {

  /** Unspecified state.
    */
  case object STATE_UNSPECIFIED extends FirebaseProjectState("STATE_UNSPECIFIED")

  /** The Project is active.
    */
  case object ACTIVE extends FirebaseProjectState("ACTIVE")

  /** The Project has been soft-deleted.
    */
  case object DELETED extends FirebaseProjectState("DELETED")
  val values = List(STATE_UNSPECIFIED, ACTIVE, DELETED)
  def fromString(input: String): Either[String, FirebaseProjectState] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for FirebaseProjectState")
  implicit val decoder: Decoder[FirebaseProjectState] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[FirebaseProjectState] = Encoder[String].contramap(_.value)
}
