package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class FirebaseProject(
    /** The user-assigned display name of the Project.
      */
    displayName: Option[String] = None,
    /** This checksum is computed by the server based on the value of other fields, and it may be sent with update requests to ensure the client has an up-to-date value before proceeding. Learn more about `etag` in Google's [AIP-154 standard](https://google.aip.dev/154#declarative-friendly-resources). This etag is strongly validated.
      */
    etag: Option[String] = None,
    /** The resource name of the Project, in the format: projects/PROJECT_IDENTIFIER PROJECT_IDENTIFIER: the Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) \*\*\*(recommended)\*\*\* or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
      */
    name: Option[String] = None,
    /** Output only. The lifecycle state of the Project.
      */
    state: Option[FirebaseProjectState] = None,
    /** Output only. Immutable. A user-assigned unique identifier for the Project. This identifier may appear in URLs or names for some Firebase resources associated with the Project, but it should generally be treated as a convenience alias to reference the Project.
      */
    projectId: Option[String] = None,
    /** A set of user-defined annotations for the FirebaseProject. Learn more about annotations in Google's [AIP-128 standard](https://google.aip.dev/128#annotations). These annotations are intended solely for developers and client-side tools. Firebase services will not mutate this annotations set.
      */
    annotations: Option[Map[String, String]] = None,
    /** Output only. Immutable. The globally unique, Google-assigned canonical identifier for the Project. Use this identifier when configuring integrations and/or making API calls to Firebase or third-party services.
      */
    projectNumber: Option[Long] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Auto-provisioning of these resources is changing, so this object no longer reliably provides information about the Project. Instead, retrieve information about each resource directly from its resource-specific API._ The default Firebase resources associated with the Project.
      */
    resources: Option[DefaultResources] = None,
)
object FirebaseProject {
  implicit val encoder: Encoder[FirebaseProject] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "etag" := x.etag,
      "name" := x.name,
      "state" := x.state,
      "projectId" := x.projectId,
      "annotations" := x.annotations,
      "projectNumber" := x.projectNumber,
      "resources" := x.resources,
    )
  }
  implicit val decoder: Decoder[FirebaseProject] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("etag")
      v2 <- c.get[Option[String]]("name")
      v3 <- c.get[Option[FirebaseProjectState]]("state")
      v4 <- c.get[Option[String]]("projectId")
      v5 <- c.get[Option[Map[String, String]]]("annotations")
      v6 <- c.get[Option[Long]]("projectNumber")
      v7 <- c.get[Option[DefaultResources]]("resources")
    } yield FirebaseProject(v0, v1, v2, v3, v4, v5, v6, v7)
  }
}
