package googleapis.firebase

import io.circe._

sealed abstract class FirebaseAppInfoPlatform(val value: String) extends Product with Serializable
object FirebaseAppInfoPlatform {

  /** Unknown state. This is only used for distinguishing unset values.
    */
  case object PLATFORM_UNSPECIFIED extends FirebaseAppInfoPlatform("PLATFORM_UNSPECIFIED")

  /** The Firebase App is associated with iOS.
    */
  case object IOS extends FirebaseAppInfoPlatform("IOS")

  /** The Firebase App is associated with Android.
    */
  case object ANDROID extends FirebaseAppInfoPlatform("ANDROID")

  /** The Firebase App is associated with web.
    */
  case object WEB extends FirebaseAppInfoPlatform("WEB")
  val values = List(PLATFORM_UNSPECIFIED, IOS, ANDROID, WEB)
  def fromString(input: String): Either[String, FirebaseAppInfoPlatform] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for FirebaseAppInfoPlatform")
  implicit val decoder: Decoder[FirebaseAppInfoPlatform] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[FirebaseAppInfoPlatform] = Encoder[String].contramap(_.value)
}
