package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class FinalizeDefaultLocationRequest(
    /** The ID of the Project's default GCP resource location. The location must be one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations).
      */
    locationId: Option[String] = None
)
object FinalizeDefaultLocationRequest {
  implicit val encoder: Encoder[
    FinalizeDefaultLocationRequest
  ] = Encoder.instance(x => Json.obj("locationId" := x.locationId))
  implicit val decoder: Decoder[
    FinalizeDefaultLocationRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("locationId")
    } yield FinalizeDefaultLocationRequest(v0)
  }
}
