package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class DefaultResources(
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the default Firebase Hosting site name using the [ListSites](https://firebase.google.com/docs/reference/hosting/rest/v1beta1/projects.sites/list) within the Firebase Hosting REST API. Note that the default site for the Project might not yet be provisioned, so the return might not contain a default site._ The default Firebase Hosting site name, in the format: PROJECT_ID Though rare, your `projectId` might already be used as the name for an existing Hosting site in another project (learn more about creating non-default, [additional sites](https://firebase.google.com/docs/hosting/multisites)). In these cases, your `projectId` is appended with a hyphen then five alphanumeric characters to create your default Hosting site name. For example, if your `projectId` is `myproject123`, your default Hosting site name might be: `myproject123-a5c16`
      */
    hostingSite: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of resources._ The ID of the Project's default GCP resource location. The location is one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations). This field is omitted if the default GCP resource location has not been finalized yet. To set a Project's default GCP resource location, call [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize) after you add Firebase resources to the Project.
      */
    locationId: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the default Firebase Realtime Database instance name using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. Note that the default instance for the Project might not yet be provisioned, so the return might not contain a default instance._ The default Firebase Realtime Database instance name, in the format: PROJECT_ID Though rare, your `projectId` might already be used as the name for an existing Realtime Database instance in another project (learn more about [database sharding](https://firebase.google.com/docs/database/usage/sharding)). In these cases, your `projectId` is appended with a hyphen then five alphanumeric characters to create your default Realtime Database instance name. For example, if your `projectId` is `myproject123`, your default database instance name might be: `myproject123-a5c16`
      */
    realtimeDatabaseInstance: Option[String] = None,
    /** Output only. \*\*DEPRECATED.\*\* _Instead, find the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. Note that the default bucket for the Project might not yet be provisioned, so the return might not contain a default bucket._ The default Cloud Storage for Firebase storage bucket, in the format: PROJECT_ID.appspot.com
      */
    storageBucket: Option[String] = None,
)
object DefaultResources {
  implicit val encoder: Encoder[DefaultResources] = Encoder.instance { x =>
    Json.obj(
      "hostingSite" := x.hostingSite,
      "locationId" := x.locationId,
      "realtimeDatabaseInstance" := x.realtimeDatabaseInstance,
      "storageBucket"
        := x.storageBucket,
    )
  }
  implicit val decoder: Decoder[DefaultResources] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("hostingSite")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("realtimeDatabaseInstance")
      v3 <- c.get[Option[String]]("storageBucket")
    } yield DefaultResources(v0, v1, v2, v3)
  }
}
