package googleapis.firebase

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector

final case class AndroidAppConfig(
    /** The contents of the JSON configuration file.
      */
    configFileContents: Option[ByteVector] = None,
    /** The filename that the configuration artifact for the `AndroidApp` is typically saved as. For example: `google-services.json`
      */
    configFilename: Option[String] = None,
)
object AndroidAppConfig {
  implicit val encoder: Encoder[AndroidAppConfig] = Encoder.instance { x =>
    Json.obj(
      "configFileContents" := x.configFileContents,
      "configFilename" := x.configFilename,
    )
  }
  implicit val decoder: Decoder[AndroidAppConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ByteVector]]("configFileContents")
      v1 <- c.get[Option[String]]("configFilename")
    } yield AndroidAppConfig(v0, v1)
  }
}
