package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AndroidApp(
    /** The user-assigned display name for the `AndroidApp`.
      */
    displayName: Option[String] = None,
    /** Output only. Timestamp of when the App will be considered expired and cannot be undeleted. This value is only provided if the App is in the `DELETED` state.
      */
    expireTime: Option[String] = None,
    /** This checksum is computed by the server based on the value of other fields, and it may be sent with update requests to ensure the client has an up-to-date value before proceeding. Learn more about `etag` in Google's [AIP-154 standard](https://google.aip.dev/154#declarative-friendly-resources). This etag is strongly validated.
      */
    etag: Option[String] = None,
    /** The resource name of the AndroidApp, in the format: projects/ PROJECT_IDENTIFIER/androidApps/APP_ID
      * PROJECT_IDENTIFIER: the parent Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) \*\*\*(recommended)\*\*\* or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
      * APP_ID: the globally unique, Firebase-assigned identifier for the App (see [`appId`](../projects.androidApps#AndroidApp.FIELDS.app_id)).
      */
    name: Option[String] = None,
    /** Output only. The lifecycle state of the App.
      */
    state: Option[AndroidAppState] = None,
    /** Immutable. The canonical package name of the Android app as would appear in the Google Play Developer Console.
      */
    packageName: Option[String] = None,
    /** Output only. Immutable. A user-assigned unique identifier of the parent FirebaseProject for the `AndroidApp`.
      */
    projectId: Option[String] = None,
    /** The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the `AndroidApp`. Be aware that this value is the UID of the API key, _not_ the [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key. The `keyString` is the value that can be found in the App's [configuration artifact](../../rest/v1beta1/projects.androidApps/getConfig). If `api_key_id` is not set in requests to [`androidApps.Create`](../../rest/v1beta1/projects.androidApps/create), then Firebase automatically associates an `api_key_id` with the `AndroidApp`. This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned. In patch requests, `api_key_id` cannot be set to an empty value, and the new UID must have no restrictions or only have restrictions that are valid for the associated `AndroidApp`. We recommend using the [Google Cloud Console](https://console.cloud.google.com/apis/credentials) to manage API keys.
      */
    apiKeyId: Option[String] = None,
    /** The SHA1 certificate hashes for the AndroidApp.
      */
    sha1Hashes: Option[List[String]] = None,
    /** Output only. Immutable. The globally unique, Firebase-assigned identifier for the `AndroidApp`. This identifier should be treated as an opaque token, as the data format is not specified.
      */
    appId: Option[String] = None,
    /** The SHA256 certificate hashes for the AndroidApp.
      */
    sha256Hashes: Option[List[String]] = None,
)
object AndroidApp {
  implicit val encoder: Encoder[AndroidApp] = Encoder.instance { x =>
    Json.obj(
      "displayName" := x.displayName,
      "expireTime" := x.expireTime,
      "etag" := x.etag,
      "name" := x.name,
      "state" := x.state,
      "packageName" := x.packageName,
      "projectId" := x.projectId,
      "apiKeyId" := x.apiKeyId,
      "sha1Hashes" := x.sha1Hashes,
      "appId" := x.appId,
      "sha256Hashes" := x.sha256Hashes,
    )
  }
  implicit val decoder: Decoder[AndroidApp] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("displayName")
      v1 <- c.get[Option[String]]("expireTime")
      v2 <- c.get[Option[String]]("etag")
      v3 <- c.get[Option[String]]("name")
      v4 <- c.get[Option[AndroidAppState]]("state")
      v5 <- c.get[Option[String]]("packageName")
      v6 <- c.get[Option[String]]("projectId")
      v7 <- c.get[Option[String]]("apiKeyId")
      v8 <- c.get[Option[List[String]]]("sha1Hashes")
      v9 <- c.get[Option[String]]("appId")
      v10 <- c.get[Option[List[String]]]("sha256Hashes")
    } yield AndroidApp(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10)
  }
}
