package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AdminSdkConfig(
    /** \*\*DEPRECATED.\*\* _Instead, find the default Firebase Realtime Database instance name using the [list endpoint](https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list) within the Firebase Realtime Database REST API. Note that the default instance for the Project might not yet be provisioned, so the return might not contain a default instance._ The default Firebase Realtime Database URL.
      */
    databaseURL: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, use product-specific REST APIs to find the location of resources._ The ID of the Project's default GCP resource location. The location is one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations). This field is omitted if the default GCP resource location has not been finalized yet. To set a Project's default GCP resource location, call [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize) after you add Firebase resources to the Project.
      */
    locationId: Option[String] = None,
    /** Immutable. A user-assigned unique identifier for the `FirebaseProject`. This identifier may appear in URLs or names for some Firebase resources associated with the Project, but it should generally be treated as a convenience alias to reference the Project.
      */
    projectId: Option[String] = None,
    /** \*\*DEPRECATED.\*\* _Instead, find the default Cloud Storage for Firebase bucket using the [list endpoint](https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list) within the Cloud Storage for Firebase REST API. Note that the default bucket for the Project might not yet be provisioned, so the return might not contain a default bucket._ The default Cloud Storage for Firebase storage bucket name.
      */
    storageBucket: Option[String] = None,
)
object AdminSdkConfig {
  implicit val encoder: Encoder[AdminSdkConfig] = Encoder.instance { x =>
    Json.obj(
      "databaseURL" := x.databaseURL,
      "locationId" := x.locationId,
      "projectId"
        := x.projectId,
      "storageBucket" := x.storageBucket,
    )
  }
  implicit val decoder: Decoder[AdminSdkConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("databaseURL")
      v1 <- c.get[Option[String]]("locationId")
      v2 <- c.get[Option[String]]("projectId")
      v3 <- c.get[Option[String]]("storageBucket")
    } yield AdminSdkConfig(v0, v1, v2, v3)
  }
}
