package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AddGoogleAnalyticsRequest(
    /** The ID for the existing [Google Analytics account](http://www.google.com/analytics/) that you want to link with the `FirebaseProject`. Specifying this field will provision a new Google Analytics property in your Google Analytics account and associate the new property with the `FirebaseProject`.
      */
    analyticsAccountId: Option[String] = None,
    /** The ID for the existing Google Analytics property that you want to associate with the `FirebaseProject`.
      */
    analyticsPropertyId: Option[String] = None,
)
object AddGoogleAnalyticsRequest {
  implicit val encoder: Encoder[
    AddGoogleAnalyticsRequest
  ] = Encoder.instance { x =>
    Json.obj(
      "analyticsAccountId" := x.analyticsAccountId,
      "analyticsPropertyId" := x.analyticsPropertyId,
    )
  }
  implicit val decoder: Decoder[
    AddGoogleAnalyticsRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("analyticsAccountId")
      v1 <- c.get[Option[String]]("analyticsPropertyId")
    } yield AddGoogleAnalyticsRequest(v0, v1)
  }
}
