package googleapis.firebase

import io.circe._
import io.circe.syntax._

final case class AddFirebaseRequest(
    /** Deprecated. Instead, to set a Project's default GCP resource location, call [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize) after you add Firebase resources to the GCP `Project`. The ID of the Project's default GCP resource location. The location must be one of the available [GCP resource locations](https://firebase.google.com/docs/projects/locations).
      */
    locationId: Option[String] = None
)
object AddFirebaseRequest {
  implicit val encoder: Encoder[AddFirebaseRequest] = Encoder.instance { x =>
    Json.obj("locationId" := x.locationId)
  }
  implicit val decoder: Decoder[AddFirebaseRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("locationId")
    } yield AddFirebaseRequest(v0)

  }
}
