package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ViewDefinition(
    // [Required] A query that BigQuery executes when the view is referenced.
    query: String,
    // True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be set using BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/
    useExplicitColumnNames: Option[Boolean] = None,
    // Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ Queries and views that reference this view must use the same flag value.
    useLegacySql: Option[Boolean] = None,
    // Describes user-defined function resources used in the query.
    userDefinedFunctionResources: Option[List[UserDefinedFunctionResource]] = None,
)
object ViewDefinition {
  implicit val encoder: Encoder[ViewDefinition] = Encoder.instance { x =>
    Json.obj(
      "query" := x.query,
      "useExplicitColumnNames" := x.useExplicitColumnNames,
      "useLegacySql" := x.useLegacySql,
      "userDefinedFunctionResources" := x.userDefinedFunctionResources,
    )
  }
  implicit val decoder: Decoder[ViewDefinition] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("query")
      v1 <- c.get[Option[Boolean]]("useExplicitColumnNames")
      v2 <- c.get[Option[Boolean]]("useLegacySql")
      v3 <- c.get[Option[List[UserDefinedFunctionResource]]]("userDefinedFunctionResources")
    } yield ViewDefinition(v0, v1, v2, v3)
  }
}
