package googleapis.bigquery

import io.circe._

sealed abstract class VectorSearchStatisticsIndexUsageMode(val value: String)
    extends Product
    with Serializable
object VectorSearchStatisticsIndexUsageMode {
  // Index usage mode not specified.
  case object INDEX_USAGE_MODE_UNSPECIFIED
      extends VectorSearchStatisticsIndexUsageMode("INDEX_USAGE_MODE_UNSPECIFIED")
  // No vector indexes were used in the vector search query. See [`indexUnusedReasons`] (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for detailed reasons.
  case object UNUSED extends VectorSearchStatisticsIndexUsageMode("UNUSED")
  // Part of the vector search query used vector indexes. See [`indexUnusedReasons`] (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for why other parts of the query did not use vector indexes.
  case object PARTIALLY_USED extends VectorSearchStatisticsIndexUsageMode("PARTIALLY_USED")
  // The entire vector search query used vector indexes.
  case object FULLY_USED extends VectorSearchStatisticsIndexUsageMode("FULLY_USED")
  val values = List(INDEX_USAGE_MODE_UNSPECIFIED, UNUSED, PARTIALLY_USED, FULLY_USED)
  def fromString(input: String): Either[String, VectorSearchStatisticsIndexUsageMode] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for VectorSearchStatisticsIndexUsageMode")
  implicit val decoder: Decoder[VectorSearchStatisticsIndexUsageMode] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[VectorSearchStatisticsIndexUsageMode] =
    Encoder[String].contramap(_.value)
}
