package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class VectorSearchStatistics(
    // When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`, this field explains why indexes were not used in all or part of the vector search query. If `indexUsageMode` is `FULLY_USED`, this field is not populated.
    indexUnusedReasons: Option[List[IndexUnusedReason]] = None,
    // Specifies the index usage mode for the query.
    indexUsageMode: Option[VectorSearchStatisticsIndexUsageMode] = None,
)
object VectorSearchStatistics {
  implicit val encoder: Encoder[VectorSearchStatistics] = Encoder.instance { x =>
    Json.obj(
      "indexUnusedReasons" := x.indexUnusedReasons,
      "indexUsageMode" := x.indexUsageMode,
    )
  }
  implicit val decoder: Decoder[
    VectorSearchStatistics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[IndexUnusedReason]]]("indexUnusedReasons")
      v1 <- c.get[Option[VectorSearchStatisticsIndexUsageMode]]("indexUsageMode")
    } yield VectorSearchStatistics(v0, v1)
  }
}
