package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class UserDefinedFunctionResource(
    // [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
    inlineCode: Option[String] = None,
    // [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
    resourceUri: Option[String] = None,
)
object UserDefinedFunctionResource {
  implicit val encoder: Encoder[
    UserDefinedFunctionResource
  ] = Encoder.instance { x =>
    Json.obj("inlineCode" := x.inlineCode, "resourceUri" := x.resourceUri)
  }
  implicit val decoder: Decoder[
    UserDefinedFunctionResource
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("inlineCode")
      v1 <- c.get[Option[String]]("resourceUri")
    } yield UserDefinedFunctionResource(v0, v1)
  }
}
