package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TransformColumn( // Output only. Name of the column.
    name: Option[String] = None, // Output only. The SQL expression used in the column transform.
    transformSql: Option[String] =
      None, // Output only. Data type of the column after the transform.
    `type`: Option[StandardSqlDataType] = None,
)
object TransformColumn {
  implicit val encoder: Encoder[TransformColumn] = Encoder.instance { x =>
    Json.obj(
      "name" := x.name,
      "transformSql" := x.transformSql,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[TransformColumn] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[Option[String]]("transformSql")
      v2 <- c.get[Option[StandardSqlDataType]]("type")
    } yield TransformColumn(v0, v1, v2)
  }
}
