package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TransactionInfo(
    // [Output-only] // [Alpha] Id of the transaction.
    transactionId: Option[String] = None
)
object TransactionInfo {
  implicit val encoder: Encoder[TransactionInfo] = Encoder.instance { x =>
    Json.obj("transactionId" := x.transactionId)
  }
  implicit val decoder: Decoder[TransactionInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("transactionId")
    } yield TransactionInfo(v0)
  }
}
