package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class TrainingRun(
    // Output only. Global explanation contains the explanation of top features on the model level. Applies to both regression and classification models.
    modelLevelGlobalExplanation: Option[GlobalExplanation] = None,
    // The model id in the [Vertex AI Model Registry](https://cloud.google.com/vertex-ai/docs/model-registry/introduction) for this training run.
    vertexAiModelId: Option[String] = None,
    // Output only. The start time of this training run.
    startTime: Option[String] = None,
    // Output only. Data split result of the training run. Only set when the input data is actually split.
    dataSplitResult: Option[DataSplitResult] = None,
    // Output only. Global explanation contains the explanation of top features on the class level. Applies to classification models only.
    classLevelGlobalExplanations: Option[List[GlobalExplanation]] = None,
    // Output only. Options that were used for this training run, includes user specified and default options that were used.
    trainingOptions: Option[TrainingOptions] = None,
    // Output only. The model version in the [Vertex AI Model Registry](https://cloud.google.com/vertex-ai/docs/model-registry/introduction) for this training run.
    vertexAiModelVersion: Option[String] = None,
    // Output only. Output of each iteration run, results.size() <= max_iterations.
    results: Option[List[IterationResult]] = None,
    // Output only. The start time of this training run, in milliseconds since epoch.
    trainingStartTime: Option[FiniteDuration] = None,
    // Output only. The evaluation metrics over training/eval data that were computed at the end of training.
    evaluationMetrics: Option[EvaluationMetrics] = None,
)
object TrainingRun {
  implicit val encoder: Encoder[TrainingRun] = Encoder.instance { x =>
    Json.obj(
      "modelLevelGlobalExplanation" := x.modelLevelGlobalExplanation,
      "vertexAiModelId" := x.vertexAiModelId,
      "startTime" := x.startTime,
      "dataSplitResult" := x.dataSplitResult,
      "classLevelGlobalExplanations" :=
        x.classLevelGlobalExplanations,
      "trainingOptions" := x.trainingOptions,
      "vertexAiModelVersion" := x.vertexAiModelVersion,
      "results" := x.results,
      "trainingStartTime" := x.trainingStartTime,
      "evaluationMetrics" := x.evaluationMetrics,
    )
  }
  implicit val decoder: Decoder[TrainingRun] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[GlobalExplanation]]("modelLevelGlobalExplanation")
      v1 <- c.get[Option[String]]("vertexAiModelId")
      v2 <- c.get[Option[String]]("startTime")
      v3 <- c.get[Option[DataSplitResult]]("dataSplitResult")
      v4 <- c.get[Option[List[GlobalExplanation]]]("classLevelGlobalExplanations")
      v5 <- c.get[Option[TrainingOptions]]("trainingOptions")
      v6 <- c.get[Option[String]]("vertexAiModelVersion")
      v7 <- c.get[Option[List[IterationResult]]]("results")
      v8 <- c.get[Option[FiniteDuration]]("trainingStartTime")
      v9 <- c.get[Option[EvaluationMetrics]]("evaluationMetrics")
    } yield TrainingRun(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9)
  }
}
