package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsTreeMethod(val value: String) extends Product with Serializable
object TrainingOptionsTreeMethod {
  // Unspecified tree method.
  case object TREE_METHOD_UNSPECIFIED extends TrainingOptionsTreeMethod("TREE_METHOD_UNSPECIFIED")
  // Use heuristic to choose the fastest method.
  case object AUTO extends TrainingOptionsTreeMethod("AUTO")
  // Exact greedy algorithm.
  case object EXACT extends TrainingOptionsTreeMethod("EXACT")
  // Approximate greedy algorithm using quantile sketch and gradient histogram.
  case object APPROX extends TrainingOptionsTreeMethod("APPROX")
  // Fast histogram optimized approximate greedy algorithm.
  case object HIST extends TrainingOptionsTreeMethod("HIST")
  val values = List(TREE_METHOD_UNSPECIFIED, AUTO, EXACT, APPROX, HIST)
  def fromString(input: String): Either[String, TrainingOptionsTreeMethod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsTreeMethod")
  implicit val decoder: Decoder[TrainingOptionsTreeMethod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsTreeMethod] = Encoder[String].contramap(_.value)
}
