package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsPcaSolver(val value: String) extends Product with Serializable
object TrainingOptionsPcaSolver {
  // Default value.
  case object UNSPECIFIED extends TrainingOptionsPcaSolver("UNSPECIFIED")
  // Full eigen-decoposition.
  case object FULL extends TrainingOptionsPcaSolver("FULL")
  // Randomized SVD.
  case object RANDOMIZED extends TrainingOptionsPcaSolver("RANDOMIZED")
  // Auto.
  case object AUTO extends TrainingOptionsPcaSolver("AUTO")
  val values = List(UNSPECIFIED, FULL, RANDOMIZED, AUTO)
  def fromString(input: String): Either[String, TrainingOptionsPcaSolver] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsPcaSolver")
  implicit val decoder: Decoder[TrainingOptionsPcaSolver] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsPcaSolver] = Encoder[String].contramap(_.value)
}
