package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsOptimizationStrategy(val value: String)
    extends Product
    with Serializable
object TrainingOptionsOptimizationStrategy {
  // Default value.
  case object OPTIMIZATION_STRATEGY_UNSPECIFIED
      extends TrainingOptionsOptimizationStrategy("OPTIMIZATION_STRATEGY_UNSPECIFIED")
  // Uses an iterative batch gradient descent algorithm.
  case object BATCH_GRADIENT_DESCENT
      extends TrainingOptionsOptimizationStrategy("BATCH_GRADIENT_DESCENT")
  // Uses a normal equation to solve linear regression problem.
  case object NORMAL_EQUATION extends TrainingOptionsOptimizationStrategy("NORMAL_EQUATION")
  val values = List(OPTIMIZATION_STRATEGY_UNSPECIFIED, BATCH_GRADIENT_DESCENT, NORMAL_EQUATION)
  def fromString(input: String): Either[String, TrainingOptionsOptimizationStrategy] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsOptimizationStrategy")
  implicit val decoder: Decoder[TrainingOptionsOptimizationStrategy] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsOptimizationStrategy] =
    Encoder[String].contramap(_.value)
}
