package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsModelRegistry(val value: String)
    extends Product
    with Serializable
object TrainingOptionsModelRegistry {
  // Default value.
  case object MODEL_REGISTRY_UNSPECIFIED
      extends TrainingOptionsModelRegistry("MODEL_REGISTRY_UNSPECIFIED")
  // Vertex AI.
  case object VERTEX_AI extends TrainingOptionsModelRegistry("VERTEX_AI")
  val values = List(MODEL_REGISTRY_UNSPECIFIED, VERTEX_AI)
  def fromString(input: String): Either[String, TrainingOptionsModelRegistry] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsModelRegistry")
  implicit val decoder: Decoder[TrainingOptionsModelRegistry] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsModelRegistry] = Encoder[String].contramap(_.value)
}
