package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsLossType(val value: String) extends Product with Serializable
object TrainingOptionsLossType {
  // Default value.
  case object LOSS_TYPE_UNSPECIFIED extends TrainingOptionsLossType("LOSS_TYPE_UNSPECIFIED")
  // Mean squared loss, used for linear regression.
  case object MEAN_SQUARED_LOSS extends TrainingOptionsLossType("MEAN_SQUARED_LOSS")
  // Mean log loss, used for logistic regression.
  case object MEAN_LOG_LOSS extends TrainingOptionsLossType("MEAN_LOG_LOSS")
  val values = List(LOSS_TYPE_UNSPECIFIED, MEAN_SQUARED_LOSS, MEAN_LOG_LOSS)
  def fromString(input: String): Either[String, TrainingOptionsLossType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsLossType")
  implicit val decoder: Decoder[TrainingOptionsLossType] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsLossType] = Encoder[String].contramap(_.value)
}
