package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsLearnRateStrategy(val value: String)
    extends Product
    with Serializable
object TrainingOptionsLearnRateStrategy {
  // Default value.
  case object LEARN_RATE_STRATEGY_UNSPECIFIED
      extends TrainingOptionsLearnRateStrategy("LEARN_RATE_STRATEGY_UNSPECIFIED")
  // Use line search to determine learning rate.
  case object LINE_SEARCH extends TrainingOptionsLearnRateStrategy("LINE_SEARCH")
  // Use a constant learning rate.
  case object CONSTANT extends TrainingOptionsLearnRateStrategy("CONSTANT")
  val values = List(LEARN_RATE_STRATEGY_UNSPECIFIED, LINE_SEARCH, CONSTANT)
  def fromString(input: String): Either[String, TrainingOptionsLearnRateStrategy] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsLearnRateStrategy")
  implicit val decoder: Decoder[TrainingOptionsLearnRateStrategy] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsLearnRateStrategy] =
    Encoder[String].contramap(_.value)
}
